<?php
function delete_old_logs() {
  $log_path = dirname(__FILE__);
  $days_to_keep = 4;
  $files = glob($log_path . "/logs/logfile_*-*-*.*");
  foreach ($files as $file) {
    $file_time = filemtime($file);
    $diff = time() - $file_time;
    if ($diff > $days_to_keep * 24 * 60 * 60) {
      unlink($file);
    }
  }
}

function log_message($message) {
    $log_path = dirname(__FILE__);
    $log_file = $log_path . "/logs/logfile_" . date("Y-m-d") . ".log";
    
    // Get the current timestamp
    $timestamp = date("Y-m-d H:i:s");
    
    // Check if log file exists for the current date, create if not
    if (!file_exists($log_file)) {
        touch($log_file);
    }
    
    // Delete old logs
    delete_old_logs($log_path);
    
    // Append timestamp and message to the log file
    error_log("[$timestamp] $message\n", 3, $log_file);
}

?>